# EG11-08 Dostawa towaru do magazynu

from BTCInput import *


class StockItem(object):
    '''
    Towar magazynowy dla sklepu z odzieżą
    '''

    show_instrumentation = False
    
    min_price = 0.5 
    max_price = 500.0 

    max_stock_add = 10

    def __init__(self, stock_ref, price, color, location):
        if StockItem.show_instrumentation:
            print('** Wywołano StockItem __init__')
        self.stock_ref = stock_ref
        self.__price = price
        self.__stock_level = 0
        self.StockItem_version = 1
        self.color = color
        self.location = location

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy StockItem')
        return 'Towar magazynowy'
        
    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy StockItem')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        pass

    def __str__(self): 
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy StockItem')
        template = '''Numer magazynowy: {0}
Typ: {1}
Lokalizacja: {2}
Cena: {3}
Stan magazynowy: {4}
Kolor: {5}''' 

        return template.format(self.stock_ref, self.item_name, self.location,
                                self.price, self.stock_level, self.color) 

    def add_stock(self,count):
        '''
        Dodaje stan magazynowy dla tego produktu. 
        Count zawiera ilość towaru do dodania
        '''
        if count < 0 or count > StockItem.max_stock_add:
            raise Exception('Nieprawidłowa ilość towaru')

        self.__stock_level = self.__stock_level + count


    @property
    def price(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get price klasy StockItem')
        return self.__price

    @property
    def stock_level(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get stock_level klasy StockItem')
        return self.__stock_level

class Dress(StockItem):

    def __init__(self, stock_ref, price, color, pattern, size, location):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __init__ klasy Dress')
        super().__init__(stock_ref=stock_ref, price=price,
                         color=color, location=location)
        self.pattern = pattern
        self.size = size
        self.Dress_version = 1

    @property
    def item_name(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę get item_name klasy Dress')
        return 'Sukienka'
        
    def check_version(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę check_version klasy Dress')
        # To jest wersja 1 - nie trzeba niczego aktualizować 
        super().check_version()
        pass

    def __str__(self):
        if StockItem.show_instrumentation:
            print('** Wywołano metodę __str__ klasy Dress')
        stock_details = super().__str__()
        template = '''{0}
Fason: {1}
Rozmiar: {2}'''
        return template.format(stock_details, self.pattern,
                               self.size) 

d = Dress(stock_ref='D01', price=100, color='czerwona', pattern='kloszowana',
          size=12, location='Okno wystawowe')

d.add_stock(5)

print(d)
